VERSION 5.00
Object = "{DFEB0DA3-D648-11D4-9C5F-EA48B7E9393D}#1.0#0"; "tvc.ocx"
Object = "{65E121D4-0C60-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCHRT20.OCX"
Begin VB.Form frmCH6VB 
   Caption         =   "Chapter 6 - Visual Basic example"
   ClientHeight    =   5820
   ClientLeft      =   13560
   ClientTop       =   -2748
   ClientWidth     =   7932
   LinkTopic       =   "Form1"
   ScaleHeight     =   5820
   ScaleWidth      =   7932
   Begin MSChart20Lib.MSChart TVCChart 
      Height          =   1695
      Left            =   120
      OleObjectBlob   =   "frmCH6VB.frx":0000
      TabIndex        =   15
      Top             =   3960
      Width           =   7695
   End
   Begin VB.Timer timMEAS 
      Left            =   8040
      Top             =   360
   End
   Begin VB.Frame Frame1 
      Caption         =   "Measurement Commands"
      Height          =   3495
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   7335
      Begin VB.CheckBox chkShowData 
         Caption         =   "Display Acquired Measurements"
         Height          =   255
         Left            =   240
         TabIndex        =   14
         Top             =   3120
         Value           =   1  'Checked
         Width           =   2895
      End
      Begin VB.CommandButton cmdClear 
         Caption         =   "Clear"
         Height          =   375
         Left            =   5760
         TabIndex        =   13
         Top             =   2520
         Width           =   1095
      End
      Begin VB.ListBox lstResults 
         Height          =   1776
         Left            =   5400
         TabIndex        =   10
         Top             =   480
         Width           =   1695
      End
      Begin VB.CommandButton cmdStop 
         Caption         =   "Stop Measurement"
         Height          =   375
         Left            =   3840
         TabIndex        =   8
         Top             =   2520
         Width           =   1695
      End
      Begin VB.ComboBox cboDuration 
         Height          =   1680
         Left            =   3480
         Style           =   1  'Simple Combo
         TabIndex        =   7
         Top             =   600
         Width           =   1575
      End
      Begin VB.ComboBox cboTimerInterval 
         Height          =   1680
         Left            =   1680
         Style           =   1  'Simple Combo
         TabIndex        =   5
         Top             =   600
         Width           =   1575
      End
      Begin VB.ComboBox cboMeasurement 
         Height          =   315
         Left            =   1680
         TabIndex        =   4
         Top             =   240
         Width           =   1575
      End
      Begin VB.CommandButton cmdMeasure 
         Caption         =   "Start Measurement"
         Height          =   375
         Left            =   2040
         TabIndex        =   1
         Top             =   2520
         Width           =   1695
      End
      Begin VB.Label lblRecordLength 
         BorderStyle     =   1  'Fixed Single
         Height          =   375
         Left            =   120
         TabIndex        =   12
         Top             =   2520
         Width           =   1575
      End
      Begin VB.Label Label4 
         Caption         =   "RecordLength:"
         Height          =   255
         Left            =   240
         TabIndex        =   11
         Top             =   2160
         Width           =   1215
      End
      Begin VB.Label Label3 
         Caption         =   "Measurements:"
         Height          =   255
         Left            =   5640
         TabIndex        =   9
         Top             =   240
         Width           =   1215
      End
      Begin VB.Label lblPrompt1 
         Caption         =   "Second Intervals:"
         Height          =   255
         Left            =   120
         TabIndex        =   6
         Top             =   600
         Width           =   1575
      End
      Begin VB.Label Label2 
         Caption         =   "Measurement:"
         Height          =   255
         Left            =   120
         TabIndex        =   3
         Top             =   240
         Width           =   1215
      End
      Begin VB.Label Label1 
         Caption         =   "Duration (Minutes):"
         Height          =   255
         Left            =   3480
         TabIndex        =   2
         Top             =   240
         Width           =   1575
      End
   End
   Begin TVCLib.Tvc Tvc1 
      Left            =   6000
      Top             =   120
      _Version        =   65536
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
      VisaDescriptor  =   "GPIB8::1::INSTR"
   End
End
Attribute VB_Name = "frmCH6VB"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim arr() ' array for holding meaurement values that are charted, chart requires a two-dimensional array
Dim NotifyCount As Long  ' counter variable for  tracking measurements
Dim StopTimerCount As Long  ' variable for holding when timer should stop

Dim strMeas As String  ' variable for sending immediate measurement command to scope

Private Sub DrawChart()
   ' routine that redraws the MSChart control
   TVCChart.Repaint = False
   TVCChart.ChartData = arr
   TVCChart.Repaint = True
   
End Sub
Private Sub CalcRecordLength()
    Dim rLength As Long
    Dim tInterval As Double
    Dim duration As Double
    Dim strD As String
    ' routine which calculates the appropriate interval for the timer and calculates
    ' the number of times the timer will fire; called in control events which change the interval
    ' and duration of the measurements
    
    If cboTimerInterval.Text = "" Then Exit Sub
    If cboDuration.Text = "" Then Exit Sub
     
     
    tInterval = Val(cboTimerInterval.Text)
    timMEAS.Interval = tInterval * 1000
    strD = cboDuration.Text
    Select Case strD
      Case ".3333 (20 seconds)"
            duration = 20
         
      Case ".5 (30 seconds)"
         
             duration = 30
         
      Case ".75 (45 seconds)"
               duration = 45
      Case Else
           duration = CLng(cboDuration.Text) * 60
    End Select
       
    
    rLength = CLng(duration / tInterval)
    StopTimerCount = rLength
    lblRecordLength.Caption = rLength
    
End Sub



Private Sub cboDuration_Click()
   CalcRecordLength
End Sub

Private Sub cboDuration_KeyPress(KeyAscii As Integer)
  If KeyAscii = 13 Then CalcRecordLength
End Sub

Private Sub cboDuration_LostFocus()
     CalcRecordLength
End Sub


Private Sub cboMeasurement_Click()
  CalcRecordLength
End Sub

Private Sub cboTimerInterval_Click()
     CalcRecordLength
End Sub

Private Sub cboTimerInterval_KeyPress(KeyAscii As Integer)
  If KeyAscii = 13 Then CalcRecordLength
End Sub

Private Sub cboTimerInterval_LostFocus()
     CalcRecordLength
End Sub



Private Sub cmdClear_Click()
  ' stop the time and redimension the array to zero
  ' redraw the chart
  Call cmdStop_Click
  lstResults.Clear
  ReDim arr(0, 0)
  arr(0, 0) = 0
  DrawChart
End Sub

Private Sub cmdMeasure_Click()
   Dim arrnum As Long
   If StopTimerCount = 0 Then
       MsgBox "Please reenter interval and duration data", vbOKOnly, "TekVisa Demo"
       Exit Sub
   End If
   NotifyCount = 0
   
   arrnum = StopTimerCount ' local variable for redimensioning array to timer count
   
   ' the VB Chart control displays the values in this array
   ReDim arr(arrnum, 0) 'redimension the array
   ' specify the measurement GPIB command
   strMeas = "MEASUREMENT:IMMED:TYPE " & cboMeasurement.Text & "; VAL?;:HEADER OFF"
   ' enable the timer
   timMEAS.Enabled = True
   
   
   
End Sub

Private Sub cmdStop_Click()
  timMEAS.Enabled = False
  DrawChart
End Sub



Private Sub Form_Load()
 Dim i As Long
 Dim axisID As VtChAxisId
 
 ' Check to see if the current device is really connected to something
 If Tvc1.InstrumentManufacturer = "" Then
      ' Oops, the device isn't available, notify the user and exit
      MsgBox "VISA Descriptor " & Tvc1.Descriptor & " not available." & Chr(10) & "You need to select an available device" & Chr(10) & "for the Tvc1 Descriptor property in the VB IDE.", vbOKOnly, "Startup Error"
      End
 End If
    
 timMEAS.Enabled = False

' populate the list box with immediate measurement GPIB commands
 With cboMeasurement
      .AddItem "AREA"
      .AddItem "BURST"
      .AddItem "CRMS"
      .AddItem "DELAY"
      .AddItem "FALL"
      .AddItem "HIGH"
      .AddItem "FREQUENCY"
      .AddItem "MAXIMUM"
      .AddItem "MINIMUM"
      .AddItem "NDUTY"
      .AddItem "NOVERSHOOT"
      .AddItem "NWIDTH"
      .AddItem "PDUTY"
      .AddItem "PERIOD"
      .AddItem "PK2PK"
      .AddItem "POVERSHOOT"
      .AddItem "PWIDTH"
      .AddItem "RISE"
      .AddItem "RMS"
    .ListIndex = 0
   
   End With
   ' populate the interval combo box
   With cboTimerInterval
     .AddItem ".25"
     .AddItem ".50"
      For i = 1 To 100
         .AddItem Str$(i)
     Next
     cboTimerInterval.ListIndex = 6
   End With
   
   ' populate the duration combo box
   With cboDuration
      .AddItem ".3333 (20 seconds)"
      .AddItem ".5 (30 seconds)"
      .AddItem ".75 (45 seconds)"
      For i = 1 To 120
         .AddItem Str(i)
      Next
     .ListIndex = 3
   End With
   
' format the chart
  axisID = VtChAxisIdX
  With TVCChart
     .chartType = VtChChartType2dLine
     .Plot.Axis(axisID).AxisScale.Type = VtChScaleTypeLinear
     .Plot.Axis(axisID).AxisScale.Hide = True
     .Plot.Axis(axisID).AxisGrid.MajorPen.Style = VtPenStyleNull
     .Plot.Axis(axisID).AxisGrid.MinorPen.Style = VtPenStyleNull
  End With
 Me.Left = Screen.Width / 10
 Me.Top = Screen.Height / 10
  

End Sub

Private Sub timMEAS_Timer()
  Dim r
  ' the main code is here
   
  ' stop the timer if it has reached the end
  If NotifyCount >= StopTimerCount Then
     timMEAS.Enabled = False
     DrawChart
     
     Exit Sub
  End If
    
  ' send command
  Tvc1.WriteString strMeas
  ' get results and format them
  r = Tvc1.ReadString
  r = Format(r, "#.#######")
  ' display captured values if the user has so specified
  If chkShowData.Value = 1 Then
      lstResults.AddItem r
  End If
  ' assign value to array
  arr(NotifyCount, 0) = r
  ' increment the counter variable
  NotifyCount = NotifyCount + 1
  ' draw the chart
  Call DrawChart
  ' make sure chart has a chance to redraw itself
  DoEvents

End Sub


